﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Web.UI;
using System.Web.UI.WebControls;

namespace Framework.Web.UI
{
    /// <summary>
    /// ラジオボタン列。通常の行選択の代わりに使えます。
    /// </summary>
    public class LRadioButtonField : System.Web.UI.WebControls.DataControlField
    {

        protected override DataControlField CreateField()
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// trueにするとラジオボタンの選択変更時に、親GridView の SelectedIndexChanged イベントが発生します。デフォルトは false です。
        /// </summary>
        public bool AutoPostBack
        {
            get { return _autoPostBack; }
            set { _autoPostBack = value; }
        }
        private bool _autoPostBack = false;


        /// <summary>
        /// 親GridViewの参照を返します。
        /// </summary>
        private GridView Parent
        {
            get { return this.Control as GridView; }
        }

        /// <summary>
        /// Initialize
        /// </summary>
        /// <param name="sortingEnabled"></param>
        /// <param name="control"></param>
        /// <returns></returns>
        public override bool Initialize(bool sortingEnabled, Control control)
        {
            control.Load += new EventHandler(gridView_Load);
            control.PreRender += new EventHandler(gridView_PreRender);

            return base.Initialize(sortingEnabled, control);
        }

        /// <summary>
        /// 親GridViewのLoadイベント
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void gridView_Load(object sender, EventArgs e)
        {
            //ラジオボタンの選択を GridView の SelectedIndex に反映する。
            this.Parent.SelectedIndex = this.GetSelectedIndex();
        }

        /// <summary>
        /// 親GridViewのPreRenderイベント
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void gridView_PreRender(object sender, EventArgs e)
        {
            //GridView の選択行を ラジオボタンに反映する。
            this.SetSelectedIndex(this.Parent.SelectedIndex);
        }

        /// <summary>
        /// InitializeCell
        /// </summary>
        /// <param name="cell"></param>
        /// <param name="cellType"></param>
        /// <param name="rowState"></param>
        /// <param name="rowIndex"></param>
        public override void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex)
        {
            if (cellType == DataControlCellType.DataCell)
            {
                //ラジオボタンコントロールの追加
                var rbo = new GridViewRadioButton()
                {
                    ID = string.Format("rbo_{0}", rowIndex),
                    GroupName = this.Parent.ClientID + "_Group",
                };
                rbo.Style[HtmlTextWriterStyle.Margin] = "0px";
                rbo.Style[HtmlTextWriterStyle.Padding] = "0px";

                if (this.AutoPostBack == true)
                {
                    rbo.Attributes["onclick"] = string.Format("javascript:__doPostBack('{0}','Select${1}')", this.Parent.ClientID, rowIndex);
                }

                cell.Controls.Add(rbo);
            }

            base.InitializeCell(cell, cellType, rowState, rowIndex);
        }

        /// <summary>
        /// 選択行の行インデックスを返します。
        /// </summary>
        /// <returns></returns>
        private int GetSelectedIndex()
        {
            var idx = -1;
            var gvw = this.Parent;
            for (int i = 0; i < gvw.Rows.Count; i++)
            {
                var rdo = gvw.Rows[i].FindControl(string.Format("rbo_{0}", i)) as GridViewRadioButton;
                if (rdo != null && rdo.Checked)
                {
                    idx = i;
                    break;
                }
            }

            return idx;
        }

        /// <summary>
        /// 選択行を設定します。
        /// </summary>
        /// <returns></returns>
        private void SetSelectedIndex(int selectedIndex)
        {
            var gvw = this.Parent;
            for (int i = 0; i < gvw.Rows.Count; i++)
            {
                var rdo = gvw.Rows[i].FindControl(string.Format("rbo_{0}", i)) as GridViewRadioButton;
                if (rdo != null)
                {
                    rdo.Checked = (i == selectedIndex);
                }
            }
        }
    }

    /// <summary>
    /// ラジオボタン列で使用するラジオボタン
    /// </summary>
    public class GridViewRadioButton : RadioButton
    {
        protected override bool LoadPostData(string postDataKey, System.Collections.Specialized.NameValueCollection postCollection)
        {
            // このコントロールが選択されたか否か
            bool newChecked = postCollection[GroupName] == this.UniqueID;

            if (this.Checked != newChecked)
            {
                this.Checked = newChecked;

                // コントロールが新たに選択されたときのみtrueを返す
                return newChecked;
            }

            return false;
        }
        
        protected override void Render(HtmlTextWriter writer)
        {
            base.Render(new WriterWrapper(writer, this));
        }

        class WriterWrapper : HtmlTextWriter
        {
            private GridViewRadioButton control;

            public WriterWrapper(HtmlTextWriter writer, GridViewRadioButton control)
                : base(writer)
            {
                this.control = control;
            }

            public override void AddAttribute(HtmlTextWriterAttribute key, string value)
            {
                switch (key)
                {
                    case HtmlTextWriterAttribute.Name:
                        base.AddAttribute(key, control.GroupName);
                        break;

                    case HtmlTextWriterAttribute.Value:
                        base.AddAttribute(key, control.UniqueID);
                        break;

                    default:
                        base.AddAttribute(key, value);
                        break;
                }
            }

        }
    }
}



